
#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>


int main( int argc, char * argv[])
{
	MPI_Init(&argc, &argv);



	int i, j;
	int  mpisize, mpirank;
	MPI_Comm_size(MPI_COMM_WORLD, &mpisize);
	MPI_Comm_rank(MPI_COMM_WORLD, &mpirank);


        // etype definition
	MPI_Datatype my_etype = MPI_INT;
        // filetype
	MPI_Datatype my_filetype;
        // type temporaire
	MPI_Datatype datatmp;

        // Create a new type (datatmp) made of mpirank+1 int in a contiguous memory area : MPI_Type_contiguous
        MPI_Type_contiguous(mpirank+1, MPI_INT, &datatmp);
	
        MPI_Aint lower_bound, extent;

	lower_bound = 0;
	extent=0;
	for(i=0; i<mpisize; i++)
	{
		if(i<mpirank)
		{
			lower_bound+=i+1;
		}
	extent+=i+1;
		
	}

        // TODO Create a file type adapted to each process so that it contains holes for data already read by other processes : MPI_Type_create_resized 

	// TODO Commit the type so that it can be used : MPI_Type_commit
	  
	int * input = malloc(sizeof(int)*mpisize);
	for(i=0; i<mpisize; i++)
	{
		input[i] = -1;
	}	

	MPI_Info wrinfo, viewinfo;
	MPI_File rdfile;
	MPI_Status wrstatus;

	MPI_File_open(MPI_COMM_WORLD, "master_write.txt", MPI_MODE_RDONLY , MPI_INFO_NULL, &rdfile);

        // Set the adapted view : MPI_File_set_view
        MPI_File_set_view(rdfile, (lower_bound)*sizeof(int), MPI_INT, my_filetype, "native", MPI_INFO_NULL);

        // Read the file (MPI_File_read_all)
        MPI_File_read_all(rdfile, input, mpirank+1, MPI_INT, &wrstatus);

	for(i=0; i<mpisize; i++)
	{
		if(i==mpirank)
		{
			printf("(%d/%d)  ", mpirank, mpisize); fflush(stdout);
			for(j=0; j<mpisize; j++)
			{
				printf("[%d]", input[j]); fflush(stdout);
			}
			printf("\n");
		}
		MPI_Barrier(MPI_COMM_WORLD);
	}


	MPI_File_close(&rdfile);


	MPI_Finalize();
	return 0;
}
